/*
 * Decompiled with CFR 0.152.
 */
package bqtweaker.client.gui;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.party.GuiPartyCreate;
import betterquesting.client.gui2.party.GuiPartyInvite;
import betterquesting.core.BetterQuesting;
import betterquesting.network.handlers.NetPartyAction;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import bqtweaker.client.gui.panels.PanelPlayerPortraitOverride;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;

public class GuiPartyManageOverride
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private IParty party;
    private int partyID = -1;
    private PanelTextField<String> flName;
    private PanelVScrollBar scUserList;

    public GuiPartyManageOverride(GuiScreen parent) {
        super(parent);
    }

    public void refreshGui() {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        DBEntry tmp = PartyManager.INSTANCE.getParty(playerID);
        if (tmp == null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyCreate(this.parent));
            return;
        }
        this.party = (IParty)tmp.getValue();
        this.partyID = tmp.getID();
        if (!this.flName.isFocused()) {
            this.flName.setText((String)this.party.getProperties().getProperty(NativeProps.NAME));
        }
        this.initPanel();
    }

    public void initPanel() {
        EnumPartyStatus status;
        super.initPanel();
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        DBEntry tmp = PartyManager.INSTANCE.getParty(playerID);
        if (tmp == null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyCreate(this.parent));
            return;
        }
        this.party = (IParty)tmp.getValue();
        this.partyID = tmp.getID();
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        EnumPartyStatus enumPartyStatus = status = NameCache.INSTANCE.isOP(playerID) ? EnumPartyStatus.OWNER : this.party.getStatus(playerID);
        if (status == null) {
            status = EnumPartyStatus.MEMBER;
        }
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
        PanelTextBox txTitle = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate((String)"betterquesting.title.party", (Object[])new Object[]{this.party.getProperties().getProperty(NativeProps.NAME)})).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel((IGuiPanel)txTitle);
        CanvasEmpty cvLeftHalf = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 64, 8, 64), 0));
        cvBackground.addPanel((IGuiPanel)cvLeftHalf);
        PanelButtonStorage btnLeave = new PanelButtonStorage((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -75, 32, 70, 16, 0), 3, QuestTranslation.translate((String)"betterquesting.btn.party_leave", (Object[])new Object[0]), (Object)this.field_146297_k.field_71439_g.func_146103_bH().getName());
        cvLeftHalf.addPanel((IGuiPanel)btnLeave);
        PanelButton btnInvite = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, 5, 32, 70, 16, 0), 2, QuestTranslation.translate((String)"betterquesting.btn.party_invite", (Object[])new Object[0]));
        cvLeftHalf.addPanel((IGuiPanel)btnInvite);
        btnInvite.setActive(status.ordinal() >= EnumPartyStatus.ADMIN.ordinal());
        if (this.flName == null) {
            this.flName = new PanelTextField((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -75, -32, 134, 16, 0), (String)this.party.getProperties().getProperty(NativeProps.NAME), (IFieldFilter)FieldFilterString.INSTANCE);
        }
        cvLeftHalf.addPanel(this.flName);
        this.flName.setActive(status.ordinal() >= EnumPartyStatus.OWNER.ordinal());
        PanelButton btnSetName = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, 0, 0, 16, 16, 0), 4, "");
        cvLeftHalf.addPanel((IGuiPanel)btnSetName);
        btnSetName.getTransform().setParent(this.flName.getTransform());
        btnSetName.setIcon(PresetIcon.ICON_REFRESH.getTexture());
        btnSetName.setActive(status.ordinal() >= EnumPartyStatus.OWNER.ordinal());
        PanelTextBox txName = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, -75, -48, 134, 16, 0), QuestTranslation.translate((String)"betterquesting.gui.name", (Object[])new Object[0]));
        txName.setColor(PresetColor.TEXT_HEADER.getColor());
        cvLeftHalf.addPanel((IGuiPanel)txName);
        CanvasEmpty cvRightHalf = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 32), 0));
        cvBackground.addPanel((IGuiPanel)cvRightHalf);
        PanelTextBox txInvite = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate((String)"betterquesting.gui.party_members", (Object[])new Object[0])).setAlignment(1);
        txInvite.setColor(PresetColor.TEXT_HEADER.getColor());
        cvRightHalf.addPanel((IGuiPanel)txInvite);
        CanvasScrolling cvUserList = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0));
        cvRightHalf.addPanel((IGuiPanel)cvUserList);
        if (this.scUserList == null) {
            this.scUserList = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(0, 0, -8, 0), 0));
        }
        cvRightHalf.addPanel((IGuiPanel)this.scUserList);
        this.scUserList.getTransform().setParent(cvUserList.getTransform());
        cvUserList.setScrollDriverY((IValueIO)this.scUserList);
        List partyMemList = this.party.getMembers();
        int elSize = RenderUtils.getStringWidth((String)"...", (FontRenderer)this.field_146289_q);
        int cvWidth = cvUserList.getTransform().getWidth();
        boolean hardcore = (Boolean)QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
        ItemTexture txHeart = new ItemTexture(new BigItemStack(BetterQuesting.extraLife));
        for (int i = 0; i < partyMemList.size(); ++i) {
            UUID mid = (UUID)partyMemList.get(i);
            String mName = NameCache.INSTANCE.getName(mid);
            if (RenderUtils.getStringWidth((String)mName, (FontRenderer)this.field_146289_q) > cvWidth - 58) {
                mName = this.field_146297_k.field_71466_p.func_78269_a(mName, cvWidth - 58 - elSize) + "...";
            }
            PanelPlayerPortraitOverride pnPortrait = new PanelPlayerPortraitOverride((IGuiRect)new GuiRectangle(0, i * 32, 32, 32, 0), mid, mName);
            cvUserList.addPanel((IGuiPanel)pnPortrait);
            PanelTextBox txMemName = new PanelTextBox((IGuiRect)new GuiRectangle(32, i * 32 + 4, cvWidth - 32, 12, 0), mName);
            txMemName.setColor(PresetColor.TEXT_MAIN.getColor());
            cvUserList.addPanel((IGuiPanel)txMemName);
            PanelButtonStorage btnKick = new PanelButtonStorage((IGuiRect)new GuiRectangle(cvWidth - 32, i * 32, 32, 32, 0), 3, QuestTranslation.translate((String)"betterquesting.btn.party_kick", (Object[])new Object[0]), (Object)mName);
            cvUserList.addPanel((IGuiPanel)btnKick);
            PanelGeneric pnItem = new PanelGeneric((IGuiRect)new GuiRectangle(32, i * 32 + 16, 16, 16, 0), (IGuiTexture)txHeart);
            cvUserList.addPanel((IGuiPanel)pnItem);
            String lifeCount = hardcore ? " x " + LifeDatabase.INSTANCE.getLives(mid) : " x \u221e";
            PanelTextBox txLives = new PanelTextBox((IGuiRect)new GuiRectangle(48, i * 32 + 20, cvWidth - 48 - 32, 12, 0), lifeCount);
            txLives.setColor(PresetColor.TEXT_MAIN.getColor());
            cvUserList.addPanel((IGuiPanel)txLives);
        }
        this.scUserList.setActive(cvUserList.getScrollBounds().getHeight() > 0);
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -32, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine((IGuiRect)ls0, (IGuiRect)le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel((IGuiPanel)paLine0);
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyInvite((GuiScreen)this));
        } else if (btn.getButtonID() == 3 && btn instanceof PanelButtonStorage) {
            String id = (String)((PanelButtonStorage)btn).getStoredValue();
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74768_a("action", 5);
            payload.func_74768_a("partyID", this.partyID);
            payload.func_74778_a("username", id);
            NetPartyAction.sendAction((NBTTagCompound)payload);
        } else if (btn.getButtonID() == 4) {
            this.party.getProperties().setProperty(NativeProps.NAME, (Object)this.flName.getRawText());
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74768_a("action", 2);
            payload.func_74768_a("partyID", this.partyID);
            payload.func_74782_a("data", (NBTBase)this.party.writeProperties(new NBTTagCompound()));
            NetPartyAction.sendAction((NBTTagCompound)payload);
        }
    }
}

